# Charity Notes 07: 晚期dei mahsaro法则解读

上一周，我们处理了塔木德中关于 dei mahsaro 原则的法律性和非法律材料。这一原则，是提供给穷人需要的东西的义务，包含那些他们主观的需求。

有一个有趣的故事是，一个音乐家为了买一个好的小提琴不得不卖掉他旧的小提琴。这样的主观需求也算慈善！塔木德带来了更多以地位为导向，看似奢侈品（如马或“在前面跑的奴隶”），给人以错误的印象。从这个dei mahsaro法则中得出的真实信息是，慈善不仅仅是担心个人的基本生活，保持身体活着 - 一个人必须考虑，更重要的是**关心整个人的个性**。也就是说慈善不仅仅是维持生存，而是尽可能的帮助对方实现自我。

正如在 Maimonides 中说的那样，“慈善的责任包括在他的特殊情况下照顾穷人的需要，对他过去的习惯和地位敏感。” Halbertat 对待了一些塔木德的故事，这些故事并没有给出一个明确的教训。

这节课是关于后塔木德时代（ post-Talmudic ）的内容。大多数的讨论是基于拉比 ==Moses Isserless==（也就是 Rema, 16世纪）和早期的 ==Maimonides==（也就是 Rambam）。

Halbertal的大部分分析都与个人提供的慈善事业和社区提供的社会救助之间的差异有关。尤其是他理解的 Maimonides 的方法在第七章和第九章是相反的。第七章是慈善事业以及个人义务，提到了 dei mahsaro；第九章是公共义务和社会慈善机构（kuappa 和 tamhui），没有提到 dei mahsaro，而只有基本生存。



## Geonim 方法

==Geonim== 中有一个有趣的观点声称，“塔木德”的裁决仅涉及一个尚未为公众所知的贫困人士。如果他的不好的情况已经被知道，没有义务向他提供像马和奴隶这样的货物。该意见将该规则解释为仅限于<u>保护贫困人员免于因丧失地位而产生的耻辱</u>。

这一段意思是，如果贫困的人的情况很清楚，就没有必要因为保护他的面子给予更多；但是如果他没有表露出这些，则对他的慈善慈善就要照顾到他的面子。

但是这一观点不被主流的法律接受。正如我们在上面的故事中所看到的，它与<u>习惯和特殊需求</u>有关。



## Rema 方法

在中世纪及以后的讨论中，Maimonides和拉比 Moses Isserles（Rema）对于这一原则有一个特殊争议，并对当代关于分配正义和道德理论的辩论显得尤为重要。十六世纪 Krakow 的 Ashkenazi 学者拉比 Moses Isserles 在对 Shulhan arukh 的批判中提到：

> **主观需要的裁决可以涉及到分配公共慈善，但是个人没有义务给穷人提供主观缺乏的东西。**他需要告诉公众穷人被剥夺的权利，如果没有其他人一起帮他资助穷人，那么这个人只需要提供他能负担得起的帮助。

他的观点来源于对**特定痛苦的潜在压倒性主张的敏感性**，这种痛苦不应该存在于个体捐助者的门口。这一引人注目的立场，违背了对塔木德文本的简单解读。



## Maimonides 方法

迈蒙尼德在解决主观需求方面对个体提供者和公共慈善的关系提出了截然不同的立场。

托拉要求每个人为穷人提供服务，但圣经材料中没有法律旨在建立照顾穷人的公共机构。塔木德文献详细地处理了个人义务的性质，并制定了一套规则，建立了一个完整的福利社区。它制定了税收规范，并规定了与负责收集和分配公共资金的官员的行为和作用有关的规则。

慈善在塔木德中被认为是一个双轨义务：<u>个体对周围人的义务和公共分享对于痛苦者和穷人的关心的负担。</u>这些个人和集体的义务可能有交集。

迈蒙尼德单独处理个人维度和集体维度。他对慈善以个人的义务开始处理，并在两章后转向集体责任。

> 在犹太人居住的每个城市，他们都有义务任命忠实的名人，作为慈善基金的受托人。他们应该在星期五到星期五之间在人民中间流传，并从每个人那里取出适合他的东西并给予他评估。然后他们从周五到周五分配**钱**，给每个穷人足够的食物七天。这叫做kupah。
>
> 同样地，我们任命受托人从每个庭院自发捐赠的人那里收取面包，不同类型的食物，水果或金钱，并将晚上从穷人中收集的东西分开，给每个穷人提供当天的**食物**。这叫做tamhui。
>
> 每个犹太社区都有kupah，但有的社区没有tamhui。

在这些章节中，迈蒙尼德描述了社区责任及其基本制度结构。然而，前两章针对的是个人及其义务，他从以下表述开始：

> 如果这是在捐助者的财政能力范围内，那么根据适合穷人的情况，向犹太人中的穷人提供慈善是一种积极的诫命，因为申命记15:5强调了这一点。你被命令根据他缺乏的东西给一个穷人。如果他缺少衣服，我们应该给他穿上衣服......

因此，迈蒙尼德对拉比伊塞尔斯后来所支持的观点提出了相反的观点。**穷人的主观需求属于个体提供者的范畴;它们不属于公共义务的范围。**似乎迈蒙尼德的立场源于对个人的基本道德姿态的特定态度，这种态度解决了具有深远影响的基本哲学问题。

伯纳德威廉姆斯（Bernard Williams）在当代道德哲学中提出了个人作为道德行为者的正确立场的问题。威廉姆斯挑战了功利主义的格言，即<u>道德和分配决策应该以最大化整体效用的尝试为指导</u>。这种要求是基于一种坚定的**平等概念**，它赋予每个个人偏好相同的权重，这个权重在行动之前必须得到公正的评估。这种功利主义的基本原则赋予整体**效用最大化**更多的权重，而不是道德计算中的代理人相对考虑。威廉姆斯批评这样一种规范，认为<u>它破坏了个人的完整性</u>，因为它禁止他追求定义他作为人类身份的个人项目和愿望。采取这种公正的立场是错误的，因为它限制了我们形成部分依恋和目标的能力，这是形成真正的个人诚信的基础。



## 两种观点的争论

迈蒙尼德和拉比伊塞尔斯之间关于解决主观需求的方式之间的争论引发了一个更为基本的问题，即关于与允许个人部分项目和目标的空间问题无关的公正立场。迈蒙尼德的裁决是，个人提供者必须解决穷人的主观需求，这意味着拒绝道德行为人必须采用非个人和公正的道德观点。

这种态度建立在一种信念上，即作为一个人的道德主体应该解决他遇到的问题，并且在解决这种需要之前从他的口袋里拿出一个计算器在道德上是错误的。**个体提供者不是一个分配的官僚，而是面对另一个关于痛苦和需要的主题。**

在提供对方的主观需要时，给予者不会倾向于他个人的偏好或者对他内心特别珍贵的事业倾向。相反，他在抵制非人格的姿态，同时拥抱和回应他与他遇到的穷人之间形成的实际关系。在这种情况下，他认为自己好像是一个非个人的普遍提供者，这在道德上是错误的。

非个人立场涉及两种不同的观点。第一个是<u>自我导向的</u>（self-directed），要求道德行为者在超越自己的偏好和目标的同时，采取公正和非个人的立场; 第二个是<u>其他人导向的</u>（other-directed），期待对他人的主张采取非个人态度。

另一方面，在迈蒙尼德的立场之后，负责分配公共资源的官员必须采用更大的非个人观点。在满足需求方面，他们必须**考虑到有限的资源**，其他穷人的需求以及这些需求之间的等级制度。个人在担任官方公众人物时，有一项公正的义务，源于他特别的机构角色和承诺。如果他在遇到他人的需要时采用关系主观立场，他就会背叛这种信任。<u>正是出于这个原因，虽然迈蒙尼德要求个体提供者提供主观需求，但在处理公共基金时没有提出这样的期望。</u>

因此，正义在满足他人需求方面的正确道德立场是<u>分层的和根据背景的。</u>在不同的角色中，将采用不同的方式，并要求采用不同的分配政策和决策。

